/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IEShader;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.q_misc_util.my_util.Plane;

public class FrontClipping {
    private static final Minecraft client = Minecraft.m_91087_();
    private static double[] activeClipPlaneEquationBeforeModelView;
    private static double[] activeClipPlaneAfterModelView;
    public static boolean isClippingEnabled;
    public static final double ADJUSTMENT = 0.01;

    public static void disableClipping() {
        if (IPGlobal.enableClippingMechanism && isClippingEnabled) {
            GL11.glDisable((int)12288);
            isClippingEnabled = false;
        }
    }

    private static void enableClipping() {
        if (IPGlobal.enableClippingMechanism && !isClippingEnabled) {
            GL11.glEnable((int)12288);
            isClippingEnabled = true;
        }
    }

    public static void updateInnerClipping(PoseStack matrixStack) {
        if (PortalRendering.isRendering()) {
            FrontClipping.setupInnerClipping(PortalRendering.getActiveClippingPlane(), matrixStack.m_85850_().m_252922_(), 0.0);
        } else {
            FrontClipping.disableClipping();
        }
    }

    public static void setupInnerClipping(Plane clipping, Matrix4f modelView, double adjustment) {
        if (!IPCGlobal.useFrontClipping) {
            return;
        }
        if (clipping != null) {
            activeClipPlaneEquationBeforeModelView = FrontClipping.getClipEquationInner(clipping.pos(), clipping.normal(), adjustment);
            activeClipPlaneAfterModelView = FrontClipping.transformClipEquation(activeClipPlaneEquationBeforeModelView, modelView);
            FrontClipping.enableClipping();
        } else {
            activeClipPlaneEquationBeforeModelView = null;
            FrontClipping.disableClipping();
        }
    }

    private static double[] transformClipEquation(double[] equation, Matrix4f modelView) {
        Vector4f eq = new Vector4f((float)equation[0], (float)equation[1], (float)equation[2], (float)equation[3]);
        Matrix4f m = new Matrix4f((Matrix4fc)modelView);
        m.invert();
        m.transpose();
        m.transform(eq);
        return new double[]{eq.x(), eq.y(), eq.z(), eq.w()};
    }

    private static double[] getClipEquationInner(Vec3 clippingPoint, Vec3 clippingDirection, double correction) {
        Vec3 cameraPos = CHelper.getCurrentCameraPos();
        Vec3 planeNormal = clippingDirection;
        Vec3 portalPos = clippingPoint.m_82549_(planeNormal.m_82490_(correction)).m_82546_(cameraPos);
        double c = planeNormal.m_82490_(-1.0).m_82526_(portalPos);
        return new double[]{planeNormal.f_82479_, planeNormal.f_82480_, planeNormal.f_82481_, c};
    }

    public static void setupOuterClipping(PoseStack matrixStack, PortalLike portalLike) {
        if (!IPCGlobal.useFrontClipping) {
            return;
        }
        if (portalLike instanceof Portal) {
            activeClipPlaneEquationBeforeModelView = FrontClipping.getClipEquationOuter((Portal)portalLike);
            activeClipPlaneAfterModelView = FrontClipping.transformClipEquation(activeClipPlaneEquationBeforeModelView, matrixStack.m_85850_().m_252922_());
            FrontClipping.enableClipping();
        } else {
            activeClipPlaneEquationBeforeModelView = null;
            FrontClipping.disableClipping();
        }
    }

    private static double[] getClipEquationOuter(Portal portal) {
        Vec3 planeNormal = portal.getNormal();
        Vec3 portalPos = portal.getOriginPos().m_82546_(FrontClipping.client.f_91063_.m_109153_().m_90583_());
        double c = planeNormal.m_82490_(-1.0).m_82526_(portalPos);
        return new double[]{planeNormal.f_82479_, planeNormal.f_82480_, planeNormal.f_82481_, c};
    }

    public static double[] getActiveClipPlaneEquationBeforeModelView() {
        return activeClipPlaneEquationBeforeModelView;
    }

    public static double[] getActiveClipPlaneEquationAfterModelView() {
        return activeClipPlaneAfterModelView;
    }

    public static void updateClippingEquationUniformForCurrentShader(boolean isRenderingEntities) {
        if (!IPGlobal.enableClippingMechanism) {
            return;
        }
        ShaderInstance shader = RenderSystem.getShader();
        if (shader == null) {
            return;
        }
        Uniform clippingEquationUniform = ((IEShader)shader).ip_getClippingEquationUniform();
        if (clippingEquationUniform != null) {
            if (isClippingEnabled) {
                double[] equation = isRenderingEntities ? activeClipPlaneAfterModelView : activeClipPlaneEquationBeforeModelView;
                clippingEquationUniform.m_5805_((float)equation[0], (float)equation[1], (float)equation[2], (float)equation[3]);
            } else {
                clippingEquationUniform.m_5805_(0.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }

    public static void unsetClippingUniform() {
        if (!IPGlobal.enableClippingMechanism) {
            return;
        }
        ShaderInstance shader = RenderSystem.getShader();
        if (shader == null) {
            return;
        }
        Uniform clippingEquationUniform = ((IEShader)shader).ip_getClippingEquationUniform();
        if (clippingEquationUniform != null) {
            clippingEquationUniform.m_5805_(0.0f, 0.0f, 0.0f, 1.0f);
        }
    }

    static {
        isClippingEnabled = false;
    }
}

